// require.config.js, require.intellisense.js
// Microsoft grants you the right to use these script files for the sole purpose of either: (i) interacting
// through your browser with the Microsoft website or online service, subject to the applicable licensing or
// use terms; or (ii) using the files as included with a Microsoft product subject to that products license
// terms. Microsoft reserves all other rights to the files not expressly granted by Microsoft, whether by implication,
// estoppel or otherwise. The notices and licenses below are for informational purposes only.
// Portions of this code are based on RequireJS 2.1.2 Copyright (c) 2010-2014, The Dojo Foundation All Rights Reserved.

// Provided for Informational Purposes Only
// MIT License
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
// modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
// is furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(function () {
    // Ensure RequireJS and the data-main attribute are defined
    if (typeof requirejs === 'undefined' ||
        typeof _$requirejs_dataMain === 'undefined') {
        return;
    }

    // Use the data-main attribute to set main script for the page
    // to load. If it is there, the path to data main becomes the
    // baseUrl, if it is not already set.
    var cfg = {};
    var dataMain = _$requirejs_dataMain;

    // Preserve dataMain in case it is a path (i.e. contains '?')
    var mainScript = dataMain;

    // Set final baseUrl if there is not already an explicit one.
    if (!cfg.baseUrl) {
        // Pull off the directory of data-main for use as the baseUrl.
        var src = mainScript.split('/');
        mainScript = src.pop();
        var subPath = src.length ? src.join('/') + '/' : './';

        cfg.baseUrl = subPath;
    }

    // Strip off any trailing .js since mainScript is now
    // like a module name.
    mainScript = mainScript.replace(requirejs.jsSuffixRegExp, '');

    // If mainScript is still a path, fall back to dataMain
    if (requirejs.jsExtRegExp.test(mainScript)) {
        mainScript = dataMain;
    }

    // Put the data-main script in the files to load.
    cfg.deps = cfg.deps ? cfg.deps.concat(mainScript) : [mainScript];

    // Disable timeouts 
    cfg.waitSeconds = 0;
    requirejs.config(cfg);
})();
// SIG // Begin signature block
// SIG // MIIkCgYJKoZIhvcNAQcCoIIj+zCCI/cCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // iaygJ1x1zMhMSHlgFaW4uYxEiZT1AWT4fdiym+W8I72g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFc8wghXLAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbowGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIFR7QQFfKIEkUFYcYC3rWRtAvSQbUysjpCHGVh5V
// SIG // 85uUME4GCisGAQQBgjcCAQwxQDA+oCSAIgByAGUAcQB1
// SIG // AGkAcgBlAC4AYwBvAG4AZgBpAGcALgBqAHOhFoAUaHR0
// SIG // cDovL21pY3Jvc29mdC5jb20wDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAn9EhGBOkeiPyndKUfY/TsjYW2KMrojYoGTh5vDNj
// SIG // 7ZAI0XnuyprygA0szXxb8u7izRtNgg1yPNg5h7ewlmZb
// SIG // 6eBEkYFYYr5wTe+b9uc9I3Z4fj2kLb4de8gvsCfVFKfH
// SIG // YLOkWlBeceRhShZY+V7qhrBo4/hHGE5sXGwOHc7FrWrB
// SIG // ec0pluQt0eoQspX5Te3ejeqZhaj9DwF+8BoDh9lBzDs9
// SIG // eEs7UdTmKaXjjTY+WLaGm9CpgEWTmtxFYhhDxouurszM
// SIG // 4j/1PBeYXZ8E3K5UZeeJlpDb11Xgl+mo51YpI+6gXA+J
// SIG // XOfMkXpTApA8yEnDZ7+lj+K8FywlHGm0JUQml6GCE00w
// SIG // ghNJBgorBgEEAYI3AwMBMYITOTCCEzUGCSqGSIb3DQEH
// SIG // AqCCEyYwghMiAgEDMQ8wDQYJYIZIAWUDBAIBBQAwggE9
// SIG // BgsqhkiG9w0BCRABBKCCASwEggEoMIIBJAIBAQYKKwYB
// SIG // BAGEWQoDATAxMA0GCWCGSAFlAwQCAQUABCDx/BCWxTE1
// SIG // xrvCmwpk0IDNK7LRYpvhiA7w2tpCfUZduAIGWIuRw2Bx
// SIG // GBMyMDE3MDIwOTAzNDMzMS44MTJaMAcCAQGAAgH0oIG5
// SIG // pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // QjFCNy1GNjdGLUZFQzIxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7QMIIGcTCCBFmg
// SIG // AwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0BAQsFADCB
// SIG // iDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUwNzAxMjE0
// SIG // NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQD
// SIG // Ex1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDCC
// SIG // ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKkd
// SIG // Dbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX77XxoSyxf
// SIG // xcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROOfGEwWbEw
// SIG // RA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNFDdDq9UeB
// SIG // zb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0ySwcSmXdFh
// SIG // E24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJUGKxXf13
// SIG // Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v0Ev9buWa
// SIG // yrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcvRLqn9Nxk
// SIG // vaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEAAaOCAeYw
// SIG // ggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1UdDgQWBBTV
// SIG // YzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEEAYI3FAIE
// SIG // DB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0T
// SIG // AQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbLj+iiXGJo
// SIG // 0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBHhkVodHRw
// SIG // Oi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9k
// SIG // dWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcmww
// SIG // WgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCBoAYDVR0g
// SIG // AQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEwPQYIKwYB
// SIG // BQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9Q
// SIG // S0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYIKwYBBQUH
// SIG // AgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwAaQBjAHkA
// SIG // XwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcN
// SIG // AQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOhIW+z66bM
// SIG // 9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceoniXj+bzt
// SIG // a1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX/1z5Xhc1
// SIG // mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIArzgPF/Uv
// SIG // eYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaPWSm8tv0E
// SIG // 4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplmkIz/amJ/
// SIG // 3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZqkHimbdLh
// SIG // nPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4ILUl5WTs
// SIG // 9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua2A5HmoDF
// SIG // 0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHhAN/nMQek
// SIG // kzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm77MbL2IK0
// SIG // cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI5pgt6o3g
// SIG // My4SKfXAL1QnIffIrE7aKLixqduWsqdCosnPGUFN4Ib5
// SIG // KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxEPJdQcdeh
// SIG // 0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgvvM9YBS7v
// SIG // DaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkSMIIE2jCC
// SIG // A8KgAwIBAgITMwAAALFxE3nfdfY1yAAAAAAAsTANBgkq
// SIG // hkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDAeFw0xNjA5MDcxNzU2NTdaFw0xODA5MDcxNzU2
// SIG // NTdaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // QjFCNy1GNjdGLUZFQzIxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0GCSqGSIb3
// SIG // DQEBAQUAA4IBDwAwggEKAoIBAQCqpCSUbVjWW7yhvQ/t
// SIG // 166a5Gfgm9GLYYSuYr3i+BudY+Z3SP/1qsDvnf0cPV2k
// SIG // bW6FhuacDFz6qy68wzR+kS+21MriVlJTuyzmsl9aZsWf
// SIG // 8nyRIYjwr2IFoHqFCQm4hfiyL2mk2v1Hehkjcdsn/JGQ
// SIG // pQ+TiGjOljoKR6FFzT9l+7q1CLKojuYKVdhlNePD6suy
// SIG // Hf+B0G9gN3fzMUGWVp/7e6KYpCBRNcaNsp+plmTe0RTe
// SIG // JtZU9TECabGUbexZOVeZTfV8LD/pNXMaDbnWWr5Djo6N
// SIG // t4f28HZM5yoSyjg1qLcnUJ0wBhR2V6VVW2BB0jH9z7ke
// SIG // +vDRjpbu4YEBadbnAgMBAAGjggEbMIIBFzAdBgNVHQ4E
// SIG // FgQUTlc994suFEtXsvwiXtPPtydEEDswHwYDVR0jBBgw
// SIG // FoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYDVR0fBE8w
// SIG // TTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29t
// SIG // L3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3RhUENBXzIw
// SIG // MTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggr
// SIG // BgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0w
// SIG // MS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEAc+6N+7Rb
// SIG // w8FOmN9ho+sAogEspyWNPj5idZtuAa+ZdTw68hQMGSS/
// SIG // yA0YYdE7kNLJJoIBEjOCfbIiF4CqHobAzbIqt9vh5UJg
// SIG // 97UJOUKx5LlM6/5Of/3mZeP43FOq+42auGAJWvQJDtvf
// SIG // GgpzANxBuDtOZ6sOBsi/aTtwSpthtT8Hcy1JfxmON/Rm
// SIG // eB0qhfQliQAQNtlyE6tGJS0Mki16A8pk9/oKN4diOuYr
// SIG // C9M5ULO/eVbS7KHXJv84N5Ef5WoQ1IcJugWISKr0qkow
// SIG // 6l6TVW9CGYjYptOVG8rzr2CPU3C5QcfxzdZe7gDRfX4I
// SIG // GZTy3SC9398WVC/DTi94paH3zqGCA3kwggJhAgEBMIHj
// SIG // oYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYD
// SIG // VQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBF
// SIG // U046QjFCNy1GNjdGLUZFQzIxJTAjBgNVBAMTHE1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoBATAJBgUr
// SIG // DgMCGgUAAxUAOrrfkyhl5HrT56P24qdEbliqU9KggcIw
// SIG // gb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNV
// SIG // BAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgTlRTIEVT
// SIG // Tjo0REU5LTBDNUUtM0UwOTErMCkGA1UEAxMiTWljcm9z
// SIG // b2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9jazANBgkq
// SIG // hkiG9w0BAQUFAAIFANxFzHQwIhgPMjAxNzAyMDgxNjU3
// SIG // MjRaGA8yMDE3MDIwOTE2NTcyNFowdzA9BgorBgEEAYRZ
// SIG // CgQBMS8wLTAKAgUA3EXMdAIBADAKAgEAAgIU0wIB/zAH
// SIG // AgEAAgIbOjAKAgUA3Ecd9AIBADA2BgorBgEEAYRZCgQC
// SIG // MSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNgoQow
// SIG // CAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQBYgqYO
// SIG // xhjzFHzfKw5/yAuSb+KEDYtHuoCwKJ4oWiiwjMSwWVhd
// SIG // YPAYUhyoUy7rgMJnJ2t/Q0azkRC6235h1GSqgPCnIWjW
// SIG // tSjv9dWRR0twgmXESu+x/KGqs13ACVDZspL7PVHKoPj0
// SIG // 37IFajymAjsbyYRu8LlQI3LoRZ/cjWar2LzqgxS1yzhn
// SIG // 269l1JneJ+RrGO+2WOVDN+qjtQzLVt1tbJVkTgVA0Dxo
// SIG // p03hFk01CPpOlHS/EGelN18a30GYzDD8BhGESqQrQPqL
// SIG // 3kM8IctaSGEbGNepbmprvKEpagyAml7VmQXi+aS10f7v
// SIG // YFofgTypIWrGpjAxr8DSWX0Y8a/nMYIC9TCCAvECAQEw
// SIG // gZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMA
// SIG // AACxcRN533X2NcgAAAAAALEwDQYJYIZIAWUDBAIBBQCg
// SIG // ggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAv
// SIG // BgkqhkiG9w0BCQQxIgQgm5Th+F8xMPVIoOruozNVTH/C
// SIG // wsO7V4X/wPKMGIy8UeYwgeIGCyqGSIb3DQEJEAIMMYHS
// SIG // MIHPMIHMMIGxBBQ6ut+TKGXketPno/bip0RuWKpT0jCB
// SIG // mDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
// SIG // BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEw
// SIG // AhMzAAAAsXETed919jXIAAAAAACxMBYEFFYXL3ClSZDH
// SIG // /LmDxBBezKo6KuEHMA0GCSqGSIb3DQEBCwUABIIBAFeR
// SIG // 1q6yPov+NDcE49WEIIlBPQEOYjZiGxHH3g9mdvlpog6J
// SIG // dpY+fbCMTYQcxHJSTmvSC7w0Cqz9S3iqWdaGfs3gEK3w
// SIG // y5G+LOYA3duR63hTxe6uvJufOirn/88SmF7xWAJNJEgR
// SIG // G6y9jIbPu+nmvTNm7dmUoBQjC+8kFSZaXK1Ow+lTydat
// SIG // zMqo9+PudOZbsR2hc6GkeLjfUQ71bOzp8JnT3TZ2ghXT
// SIG // a8qEQ7rEZFmqWFGuJl86+m0qthm+ELyhiwk7pVs0lGP2
// SIG // 85QCzQ2HDbCyjlPj+66chsHYYVnuQe35t6qUymyq1ain
// SIG // aFjCBkGhwCxNaJdOK2A4Pw2MFYyNweQ=
// SIG // End signature block
